<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Podcast extends Eloquent {

	protected $table = 'podcasts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function episodes()
	{
		return $this->hasMany('Episode');
	}

	public function categories()
	{
		return $this->belongsToMany('Category');
	}

	public function quiz()
	{
		return $this->morphOne('Quiz', 'quizzable');
	}

}