<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Question extends Eloquent {

	protected $table = 'questions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function quiz()
	{
		return $this->belongsTo('Quiz');
	}

	public function options()
	{
		return $this->hasMany('QuizOption');
	}

	public function correct()
	{
		return $this->belongsTo('QuizOption');
	}

}