<?php

namespace Wolfie\Models;

class Thread extends Eloquent {

	protected $table = 'threads';
	public $timestamps = true;
	protected $fillable = array('threadable_type', 'threadable_id', 'pro_id', 'client_id');

	public function client()
	{
		return $this->belongsTo('Client', 'client_id')->withPivot();
	}

	public function pro()
	{
		return $this->belongsTo('Pro', 'pro_id')->withPivot();
	}

	public function threadable()
	{
		return $this->morphTo();
	}

	public function messages()
	{
		return $this->hasMany('Thread', 'thread_id');
	}

}