<?php

namespace Wolfie\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'password', 'phone', 'location', 'cords', 'gender', 'image', 'facebook_id', 'facebook_token', 'facebook_refresh_token', 'facebook_photo', 'email_verification_token', 'active', 'acting_as', 'remember_token');
	protected $visible = array('acting_as', 'remember_token');

	public function client()
	{
		return $this->hasOne('Client', 'user_id');
	}

	public function pro()
	{
		return $this->hasOne('Pro', 'user_id');
	}

}