<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('reviewable_type', 255)->nullable()->index();
			$table->integer('reviewable_id')->unsigned()->nullable()->index();
			$table->string('authorable_type', 255)->nullable()->index();
			$table->integer('authorable_id')->unsigned()->nullable()->index();
			$table->integer('client_id')->unsigned()->nullable()->index();
			$table->integer('pro_id')->unsigned()->nullable()->index();
			$table->text('body')->nullable();
			$table->string('image', 255)->nullable()->index();
			$table->integer('rating')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}