<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->index();
			$table->string('email', 255)->unique();
			$table->string('password', 255);
			$table->string('phone', 255)->nullable();
			$table->string('location', 255)->nullable();
			$table->string('cords', 255)->nullable();
			$table->enum('gender', array(''m'', ''f''))->nullable();
			$table->string('image', 255)->nullable();
			$table->string('facebook_id', 255)->nullable();
			$table->string('facebook_token', 255)->nullable();
			$table->string('facebook_refresh_token', 255)->nullable();
			$table->string('facebook_photo', 255);
			$table->string('email_verification_token')->nullable();
			$table->integer('active')->default('1');
			$table->string('acting_as');
			$table->string('remember_token');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}