<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketTable extends Migration {

	public function up()
	{
		Schema::create('ticket', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('client_id');
			$table->bigInteger('user_id');
			$table->bigInteger('technical_id')->unsigned()->nullable();
			$table->bigInteger('category_id')->unsigned();
			$table->string('subject');
			$table->string('description');
			$table->enum('priority', array('low', 'medium', 'hight', 'critical'));
			$table->enum('status', array('open', 'closed'));
			$table->date('date_to_solution_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('ticket');
	}
}