<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('user_profile')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('login_type')->references('id')->on('login_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_profile_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_login_type_foreign');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->dropForeign('user_profile_country_id_foreign');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->dropForeign('user_profile_city_id_foreign');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->dropForeign('places_city_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
	}
}