<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLiensTable extends Migration {

	public function up()
	{
		Schema::create('liens', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->integer('height')->nullable();
			$table->integer('width')->nullable();
			$table->integer('vessel_id')->unsigned();
			$table->integer('max_weight')->unsigned()->nullable();
			$table->integer('max_capacity')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('liens');
	}
}