<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('seat_calss')->unsigned();
			$table->integer('ticket_class')->unsigned();
			$table->integer('pax')->nullable();
			$table->enum('share_type', array('1', '2', '3'))->nullable();
			$table->integer('seat_from')->nullable();
			$table->integer('seat_to')->nullable();
			$table->float('price')->nullable();
			$table->integer('trip_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}