<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->enum('action_type', array('add', 'detuct'))->nullable();
			$table->float('amount')->nullable();
			$table->float('new_balance')->nullable();
			$table->integer('created_by')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}