<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTripsTable extends Migration {

	public function up()
	{
		Schema::create('trips', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('route_id')->unsigned()->nullable();
			$table->integer('vessel_id')->nullable();
			$table->datetime('departure')->nullable();
			$table->string('trip_number', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('trips');
	}
}