<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('account_services', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('account_service_options', function(Blueprint $table) {
			$table->foreign('account_service_id')->references('id')->on('account_services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('account_service_extras', function(Blueprint $table) {
			$table->foreign('account_service_id')->references('id')->on('account_services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('booked_service_options', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('booked_service_options', function(Blueprint $table) {
			$table->foreign('account_service_option_id')->references('id')->on('account_service_options')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('booked_service_extras', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('booked_service_extras', function(Blueprint $table) {
			$table->foreign('account_service_extras_id')->references('id')->on('account_service_extras')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('booking_address', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('account_services', function(Blueprint $table) {
			$table->dropForeign('account_services_account_id_foreign');
		});
		Schema::table('account_service_options', function(Blueprint $table) {
			$table->dropForeign('account_service_options_account_service_id_foreign');
		});
		Schema::table('account_service_extras', function(Blueprint $table) {
			$table->dropForeign('account_service_extras_account_service_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_account_id_foreign');
		});
		Schema::table('booked_service_options', function(Blueprint $table) {
			$table->dropForeign('booked_service_options_booking_id_foreign');
		});
		Schema::table('booked_service_options', function(Blueprint $table) {
			$table->dropForeign('booked_service_options_account_service_option_id_foreign');
		});
		Schema::table('booked_service_extras', function(Blueprint $table) {
			$table->dropForeign('booked_service_extras_booking_id_foreign');
		});
		Schema::table('booked_service_extras', function(Blueprint $table) {
			$table->dropForeign('booked_service_extras_account_service_extras_id_foreign');
		});
		Schema::table('booking_address', function(Blueprint $table) {
			$table->dropForeign('booking_address_booking_id_foreign');
		});
	}
}