<?php

namespace App\Models;

class Booking extends Eloquent {

	protected $table = 'bookings';
	public $timestamps = true;
	protected $fillable = array('user_id', 'account_id');

	public function serviceOptions()
	{
		return $this->hasManyThrough('App\Models\ServiceOption', 'App\Models\BookedServiceOption', 'booking_id', 'account_service_option_id');
	}

	public function serviceExtras()
	{
		return $this->hasManyThrough('App\Models\ServiceExtra', 'App\Models\BookedServiceExtra', 'booking_id', 'account_service_extras_id');
	}

	public function address()
	{
		return $this->hasOne('App\Models\BookingAddress');
	}

}