<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Wallet extends Model 
{

    protected $table = 'wallets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function allocations()
    {
        return $this->hasMany('Allocation');
    }

    public function wallet_provider()
    {
        return $this->belongsTo('WalletProvider');
    }

}