<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Allocation extends Eloquent {

	protected $table = 'allocations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function wallet()
	{
		return $this->belongsTo('Wallet');
	}

	public function project()
	{
		return $this->belongsTo('Project');
	}

	public function transactions()
	{
		return $this->hasMany('User');
	}

}