<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $hidden = array('password');

	public function wallets()
	{
		return $this->hasMany('Wallet');
	}

	public function allocations()
	{
		return $this->hasMany('Allocation');
	}

	public function events()
	{
		return $this->morphMany('Activity', 'eventable');
	}

}