<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Wallet extends Eloquent {

	protected $table = 'wallets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function allocations()
	{
		return $this->hasMany('Allocation');
	}

	public function wallet_provider()
	{
		return $this->belongsTo('WalletProvider');
	}

}