<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAllocationsTable extends Migration {

	public function up()
	{
		Schema::create('allocations', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->index();
			$table->bigInteger('project_id')->unsigned()->index();
			$table->bigInteger('wallet_id')->unique();
			$table->bigInteger('usdt_amount')->unsigned()->default('0');
			$table->bigInteger('wozx_amount')->unsigned()->index()->default('0');
			$table->datetime('confirmed_at')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('allocations');
	}
}