<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function phones()
    {
        return $this->hasMany('ClientPhone');
    }

    public function addresses()
    {
        return $this->hasMany('Address', 'client_id');
    }

    public function orders()
    {
        return $this->hasMany('Order', 'client_id');
    }

}