<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttachmentsTable extends Migration {

	public function up()
	{
		Schema::create('attachments', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->nullableMorphs('related');
			$table->string('path')->nullable();
			$table->string('extension');
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->tinyInteger('privacy')->unsigned()->default('1');
			$table->tinyInteger('key')->nullable();
			$table->bigInteger('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('attachments');
	}
}