<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateElectronicSignaturesTable extends Migration {

	public function up()
	{
		Schema::create('electronic_signatures', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->morphs('related');
			$table->string('online_document_id')->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->string('user_email');
			$table->json('user_version');
			$table->string('invitation_role')->nullable();
			$table->integer('invitation_order');
			$table->tinyInteger('status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('electronic_signatures');
	}
}