<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProcessExecutionStepsTable extends Migration {

	public function up()
	{
		Schema::create('process_execution_steps', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('process_execution_id')->unsigned();
			$table->bigInteger('process_step_version_id')->unsigned();
			$table->json('process_step_version_actions')->nullable();
			$table->json('data')->nullable();
			$table->datetime('start_date')->nullable();
			$table->datetime('end_date')->nullable();
			$table->datetime('deadline_date')->nullable();
			$table->integer('actions_count')->unsigned()->default('0');
			$table->integer('done_actions_count')->unsigned()->default('0');
			$table->tinyInteger('status')->unsigned()->default('2');
		});
	}

	public function down()
	{
		Schema::drop('process_execution_steps');
	}
}