<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('category_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->text('content_ar');
			$table->text('content_en')->nullable();
			$table->tinyInteger('status')->unsigned()->default('2');
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}