<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDynamicFormsTable extends Migration {

	public function up()
	{
		Schema::create('dynamic_forms', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_ar');
			$table->string('name_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->text('description_en')->nullable();
			$table->tinyInteger('will_be_signed')->unsigned()->default('2');
			$table->string('signers_data');
			$table->json('signature_invitation_data')->nullable();
			$table->tinyInteger('status')->unsigned()->default('1');
		});
	}

	public function down()
	{
		Schema::drop('dynamic_forms');
	}
}