<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProcessExecutionTable extends Migration {

	public function up()
	{
		Schema::create('process_execution', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('process_id')->unsigned();
			$table->json('process_version')->nullable();
			$table->json('process_steps_version')->nullable();
			$table->datetime('start_date')->nullable();
			$table->datetime('end_date')->nullable();
			$table->datetime('deadline_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('process_execution');
	}
}