<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProcessStepActionsTable extends Migration {

	public function up()
	{
		Schema::create('process_step_actions', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('process_step_id')->unsigned();
			$table->json('process_step_version')->nullable();
			$table->morphs('target');
			$table->morphs('component');
			$table->json('component_version')->nullable();
			$table->integer('order')->unsigned();
			$table->json('result')->nullable();
			$table->bigInteger('process_step_action_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('process_step_actions');
	}
}