<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('department_user', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('department_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('process_steps', function(Blueprint $table) {
			$table->foreign('process_id')->references('id')->on('processes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('process_step_actions', function(Blueprint $table) {
			$table->foreign('process_step_id')->references('id')->on('process_steps')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('process_step_actions', function(Blueprint $table) {
			$table->foreign('process_step_action_id')->references('id')->on('process_step_actions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('dynamic_form_fields', function(Blueprint $table) {
			$table->foreign('dynamic_form_id')->references('id')->on('dynamic_forms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('file_template', function(Blueprint $table) {
			$table->foreign('file_template_id')->references('id')->on('file_template')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('process_execution', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('process_execution', function(Blueprint $table) {
			$table->foreign('process_id')->references('id')->on('processes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('process_execution_steps', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('process_execution_steps', function(Blueprint $table) {
			$table->foreign('process_execution_id')->references('id')->on('process_execution')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('electronic_signatures', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_department', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_department', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('department_user', function(Blueprint $table) {
			$table->dropForeign('department_user_department_id_foreign');
		});
		Schema::table('department_user', function(Blueprint $table) {
			$table->dropForeign('department_user_user_id_foreign');
		});
		Schema::table('process_steps', function(Blueprint $table) {
			$table->dropForeign('process_steps_process_id_foreign');
		});
		Schema::table('process_step_actions', function(Blueprint $table) {
			$table->dropForeign('process_step_actions_process_step_id_foreign');
		});
		Schema::table('process_step_actions', function(Blueprint $table) {
			$table->dropForeign('process_step_actions_process_step_action_id_foreign');
		});
		Schema::table('dynamic_form_fields', function(Blueprint $table) {
			$table->dropForeign('dynamic_form_fields_dynamic_form_id_foreign');
		});
		Schema::table('file_template', function(Blueprint $table) {
			$table->dropForeign('file_template_file_template_id_foreign');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->dropForeign('attachments_user_id_foreign');
		});
		Schema::table('process_execution', function(Blueprint $table) {
			$table->dropForeign('process_execution_user_id_foreign');
		});
		Schema::table('process_execution', function(Blueprint $table) {
			$table->dropForeign('process_execution_process_id_foreign');
		});
		Schema::table('process_execution_steps', function(Blueprint $table) {
			$table->dropForeign('process_execution_steps_user_id_foreign');
		});
		Schema::table('process_execution_steps', function(Blueprint $table) {
			$table->dropForeign('process_execution_steps_process_execution_id_foreign');
		});
		Schema::table('electronic_signatures', function(Blueprint $table) {
			$table->dropForeign('electronic_signatures_user_id_foreign');
		});
		Schema::table('category_department', function(Blueprint $table) {
			$table->dropForeign('category_department_category_id_foreign');
		});
		Schema::table('category_department', function(Blueprint $table) {
			$table->dropForeign('category_department_department_id_foreign');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_category_id_foreign');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_user_id_foreign');
		});
	}
}