<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ActionList extends Eloquent {

	protected $table = 'action_lists';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en', 'type', 'data', 'status');

	public function component()
	{
		return $this->morphMany('App\Models\ProcessStepAction', 'component');
	}

	public function formFields()
	{
		return $this->morphMany('App\Models\DynamicFormField', 'component');
	}

}