<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en');

	public function departments()
	{
		return $this->belongsToMany('App\Models\Department', 'category_department', 'category_id', 'department_id');
	}

	public function tasks()
	{
		return $this->hasMany('App\Models\Task');
	}

}