<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Department extends Eloquent {

	protected $table = 'departments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en', 'status');

	public function users()
	{
		return $this->belongsToMany('App\Models\User')->withPivot();
	}

	public function steps()
	{
		return $this->morphMany('App\Models\ProcessStep', 'target');
	}

	public function actions()
	{
		return $this->morphMany('App\Models\ProcessStepAction', 'target');
	}

	public function departments()
	{
		return $this->belongsToMany('App\Models\Category', 'category_department', 'department_id', 'category_id');
	}

}