<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DynamicForm extends Eloquent {

	protected $table = 'dynamic_forms';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en', 'description_ar', 'description_en', 'will_be_signed', 'signature_invitation_data', 'status');

	public function fields()
	{
		return $this->hasMany('App\Models\DynamicFormField');
	}

}