<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DynamicFormField extends Eloquent {

	protected $table = 'dynamic_form_fields';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('dynamic_form_id', 'name_ar', 'name_en', 'type', 'data', 'component');

	public function form()
	{
		return $this->belongsTo('App\Models\DynamicForm');
	}

	public function component()
	{
		return $this->morphTo();
	}

}