<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DynamicList extends Eloquent {

	protected $table = 'dynamic_lists';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en', 'description_ar', 'description_en', 'type', 'data', 'status');

	public function formFields()
	{
		return $this->morphMany('App\Models\DynamicFormField', 'component');
	}

	public function stepActions()
	{
		return $this->morphMany('App\Models\ProcessStepAction', 'component');
	}

}