<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FileTemplate extends Eloquent {

	protected $table = 'file_template';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en', 'content_ar', 'content_en', 'type', 'file_template_id');

	public function template()
	{
		return $this->belongsTo('App\Models\FileTemplate', 'file_template_id');
	}

	public function copies()
	{
		return $this->hasMany('App\Models\FileTemplate', 'file_template_id');
	}

	public function processStepActions()
	{
		return $this->morphMany('App\Models\ProcessStepAction', 'component');
	}

}