<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProcessStep extends Eloquent {

	protected $table = 'process_steps';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id', 'process_id', 'process_version', 'name_ar', 'name_en', 'order', 'target');

	public function duration()
	{
		return $this->morphOne('App\Models\User', 'related');
	}

	public function target()
	{
		return $this->morphTo();
	}

}