<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ReadableLog extends Eloquent {

	protected $table = 'readable_logs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('related', 'name_ar', 'name_en', 'content_ar', 'content_en', 'causer');

	public function causer()
	{
		return $this->morphTo();
	}

	public function related()
	{
		return $this->morphTo();
	}

}