<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificacionesTable extends Migration {

	public function up()
	{
		Schema::create('notificaciones', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->integer('tipo_estado_solicitud_id')->unsigned()->nullable();
			$table->text('description')->index();
			$table->text('description_br')->nullable();
			$table->text('description_es')->nullable();
			$table->boolean('active')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('notificaciones');
	}
}