<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Bloque extends Eloquent {

	protected $table = 'bloques';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'active');
	protected $visible = array('name', 'active');

	public function bloques_peliculas()
	{
		return $this->hasMany('BloquePelicula', 'bloque_id');
	}

}