<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DestinatarioNotificacion extends Eloquent {

	protected $table = 'destinatarios_notificaciones';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('notificacion_id', 'user_id', 'name', 'email');
	protected $visible = array('notificacion_id', 'user_id', 'name', 'email');

	public function notificacion()
	{
		return $this->belongsTo('Notificacion', 'notificacion_id')->withTrashed();
	}

}