<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DetalleLiquidacion extends Eloquent {

	protected $table = 'detalle_liquidaciones';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('liquidaciones_id', 'valor', 'label', 'distribuidora_id');
	protected $visible = array('liquidaciones_id', 'valor', 'label', 'distribuidora_id');

	public function distribuidora()
	{
		return $this->belongsTo('Distribuidora', 'distribuidora_id')->withTrashed();
	}

	public function liquidacion()
	{
		return $this->belongsTo('Liquidacion', 'liquidacion_id')->withTrashed();
	}

}