<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Distribuidora extends Eloquent {

	protected $table = 'distribuidoras';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'pais_id', 'code', 'tipo_distribuidora_id');
	protected $visible = array('name', 'description', 'pais_id', 'tipo_distribuidora_id');
	protected $hidden = array('code');

	public function tipo_distribuidora()
	{
		return $this->belongsTo('TipoDistribuidora', 'tipo_distribuidora_id')->withTrashed();
	}

	public function pais()
	{
		return $this->belongsTo('Pais', 'pais_id')->withTrashed();
	}

}