<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EstadoLiquidacionLiquidacion extends Eloquent {

	protected $table = 'estado_liquidaciones_liquidaciones';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('liquidacion_id', 'estado_liquidacion_id');
	protected $visible = array('liquidacion_id', 'estado_liquidacion_id');

	public function estado_liquidacion()
	{
		return $this->belongsTo('EstadoLiquidacion', 'estado_liquidacion_id')->withTrashed();
	}

	public function liquidacion()
	{
		return $this->belongsTo('Liquidacion', 'liquidacion_id')->withTrashed();
	}

}