<?php

namespace App\Models;

class Solicitud extends Eloquent {

	protected $table = 'solicitudes';
	public $timestamps = true;
	protected $fillable = array('pelicula_id', 'pais_id', 'distribuidoras_id', 'tipo_solicitud_id');
	protected $visible = array('pelicula_id', 'pais_id', 'distribuidoras_id', 'tipo_solicitud_id');

	public function detalles()
	{
		return $this->hasMany('DetalleSolicitud', 'solicitud_id');
	}

	public function tipo_solicitud()
	{
		return $this->belongsTo('TipoSolicitud', 'tipo_solicitud_id')->withTrashed();
	}

	public function distribuidora()
	{
		return $this->belongsTo('Distribuidora', 'distribuidora_id')->withTrashed();
	}

	public function pais()
	{
		return $this->belongsTo('Pais', 'pais_id')->withTrashed();
	}

	public function pelicula()
	{
		return $this->belongsTo('Pelicula', 'pelicula_id')->withTrashed();
	}

}