<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tax extends Eloquent {

	protected $table = 'taxes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'percentage', 'pais_id');
	protected $visible = array('name', 'percentage', 'pais_id');

	public function pais()
	{
		return $this->belongsTo('Pais', 'pais_id')->withTrashed();
	}

}