<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('distribuidoras', function(Blueprint $table) {
			$table->foreign('pais_id')->references('id')->on('paises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('distribuidoras', function(Blueprint $table) {
			$table->foreign('tipo_distribuidora_id')->references('id')->on('tipo_distribuidoras')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('solicitudes', function(Blueprint $table) {
			$table->foreign('pelicula_id')->references('id')->on('peliculas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('solicitudes', function(Blueprint $table) {
			$table->foreign('pais_id')->references('id')->on('paises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('solicitudes', function(Blueprint $table) {
			$table->foreign('distribuidoras_id')->references('id')->on('distribuidoras')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('solicitudes', function(Blueprint $table) {
			$table->foreign('tipo_solicitud_id')->references('id')->on('tipo_solicitudes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tipo_solicitudes', function(Blueprint $table) {
			$table->foreign('modulos_id')->references('id')->on('modulos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('detalle_solicitudes', function(Blueprint $table) {
			$table->foreign('campo_solicitud_id')->references('id')->on('tipo_campos_solicitudes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('detalle_solicitudes', function(Blueprint $table) {
			$table->foreign('solicitud_id')->references('id')->on('solicitudes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campos_solicitud', function(Blueprint $table) {
			$table->foreign('tipo_solicitud_id')->references('id')->on('tipo_solicitudes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campos_solicitud', function(Blueprint $table) {
			$table->foreign('tipo_campo_solicitud_id')->references('id')->on('tipo_campos_solicitudes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estados_solicitudes', function(Blueprint $table) {
			$table->foreign('solicitud_id')->references('id')->on('solicitudes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estados_solicitudes', function(Blueprint $table) {
			$table->foreign('tipo_estado_solicitud_id')->references('id')->on('tipo_estados_solicitudes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tipo_estados_solicitudes', function(Blueprint $table) {
			$table->foreign('previous_state_id')->references('id')->on('tipo_estados_solicitudes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notificaciones_solicitud', function(Blueprint $table) {
			$table->foreign('notificacion_id')->references('id')->on('notificaciones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notificaciones_solicitud', function(Blueprint $table) {
			$table->foreign('solicitud_id')->references('id')->on('solicitudes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notificaciones', function(Blueprint $table) {
			$table->foreign('tipo_estado_solicitud_id')->references('id')->on('tipo_estados_solicitudes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('destinatarios_notificaciones', function(Blueprint $table) {
			$table->foreign('notificacion_id')->references('id')->on('notificaciones_solicitud')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('destinatarios_reportes', function(Blueprint $table) {
			$table->foreign('reporte_id')->references('id')->on('reportes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lineup_peliculas', function(Blueprint $table) {
			$table->foreign('pelicula_id')->references('id')->on('peliculas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bloques_peliculas', function(Blueprint $table) {
			$table->foreign('bloques_id')->references('id')->on('bloques')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bloques_peliculas', function(Blueprint $table) {
			$table->foreign('pelicula_id')->references('id')->on('peliculas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('liquidaciones', function(Blueprint $table) {
			$table->foreign('pelicula_id')->references('id')->on('peliculas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('liquidaciones', function(Blueprint $table) {
			$table->foreign('tipo_liquidacion_id')->references('id')->on('tipo_liquidaciones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('taxes', function(Blueprint $table) {
			$table->foreign('pais_id')->references('id')->on('paises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('estado_liquidaciones_liquidaciones', function(Blueprint $table) {
			$table->foreign('liquidacion_id')->references('id')->on('liquidaciones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('distribuidoras', function(Blueprint $table) {
			$table->dropForeign('distribuidoras_pais_id_foreign');
		});
		Schema::table('distribuidoras', function(Blueprint $table) {
			$table->dropForeign('distribuidoras_tipo_distribuidora_id_foreign');
		});
		Schema::table('solicitudes', function(Blueprint $table) {
			$table->dropForeign('solicitudes_pelicula_id_foreign');
		});
		Schema::table('solicitudes', function(Blueprint $table) {
			$table->dropForeign('solicitudes_pais_id_foreign');
		});
		Schema::table('solicitudes', function(Blueprint $table) {
			$table->dropForeign('solicitudes_distribuidoras_id_foreign');
		});
		Schema::table('solicitudes', function(Blueprint $table) {
			$table->dropForeign('solicitudes_tipo_solicitud_id_foreign');
		});
		Schema::table('tipo_solicitudes', function(Blueprint $table) {
			$table->dropForeign('tipo_solicitudes_modulos_id_foreign');
		});
		Schema::table('detalle_solicitudes', function(Blueprint $table) {
			$table->dropForeign('detalle_solicitudes_campo_solicitud_id_foreign');
		});
		Schema::table('detalle_solicitudes', function(Blueprint $table) {
			$table->dropForeign('detalle_solicitudes_solicitud_id_foreign');
		});
		Schema::table('campos_solicitud', function(Blueprint $table) {
			$table->dropForeign('campos_solicitud_tipo_solicitud_id_foreign');
		});
		Schema::table('campos_solicitud', function(Blueprint $table) {
			$table->dropForeign('campos_solicitud_tipo_campo_solicitud_id_foreign');
		});
		Schema::table('estados_solicitudes', function(Blueprint $table) {
			$table->dropForeign('estados_solicitudes_solicitud_id_foreign');
		});
		Schema::table('estados_solicitudes', function(Blueprint $table) {
			$table->dropForeign('estados_solicitudes_tipo_estado_solicitud_id_foreign');
		});
		Schema::table('tipo_estados_solicitudes', function(Blueprint $table) {
			$table->dropForeign('tipo_estados_solicitudes_previous_state_id_foreign');
		});
		Schema::table('notificaciones_solicitud', function(Blueprint $table) {
			$table->dropForeign('notificaciones_solicitud_notificacion_id_foreign');
		});
		Schema::table('notificaciones_solicitud', function(Blueprint $table) {
			$table->dropForeign('notificaciones_solicitud_solicitud_id_foreign');
		});
		Schema::table('notificaciones', function(Blueprint $table) {
			$table->dropForeign('notificaciones_tipo_estado_solicitud_id_foreign');
		});
		Schema::table('destinatarios_notificaciones', function(Blueprint $table) {
			$table->dropForeign('destinatarios_notificaciones_notificacion_id_foreign');
		});
		Schema::table('destinatarios_reportes', function(Blueprint $table) {
			$table->dropForeign('destinatarios_reportes_reporte_id_foreign');
		});
		Schema::table('lineup_peliculas', function(Blueprint $table) {
			$table->dropForeign('lineup_peliculas_pelicula_id_foreign');
		});
		Schema::table('bloques_peliculas', function(Blueprint $table) {
			$table->dropForeign('bloques_peliculas_bloques_id_foreign');
		});
		Schema::table('bloques_peliculas', function(Blueprint $table) {
			$table->dropForeign('bloques_peliculas_pelicula_id_foreign');
		});
		Schema::table('liquidaciones', function(Blueprint $table) {
			$table->dropForeign('liquidaciones_pelicula_id_foreign');
		});
		Schema::table('liquidaciones', function(Blueprint $table) {
			$table->dropForeign('liquidaciones_tipo_liquidacion_id_foreign');
		});
		Schema::table('taxes', function(Blueprint $table) {
			$table->dropForeign('taxes_pais_id_foreign');
		});
		Schema::table('estado_liquidaciones_liquidaciones', function(Blueprint $table) {
			$table->dropForeign('estado_liquidaciones_liquidaciones_liquidacion_id_foreign');
		});
	}
}