<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Robot extends Model 
{

    protected $table = 'Robots';
    public $timestamps = false;

    public function missions()
    {
        return $this->hasMany('Mission');
    }

    public function configuration()
    {
        return $this->hasOne('Configuration');
    }

    public function systems()
    {
        return $this->belongsToMany('System');
    }

    public function company()
    {
        return $this->hasOne('Company');
    }

}