<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('lastname', 50);
			$table->string('firstname', 50);
			$table->string('username', 30)->unique();
			$table->string('email')->unique();
			$table->string('password');
			$table->string('api_token');
			$table->integer('id_company')->unique()->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}