<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('organisation_applications', function(Blueprint $table) {
			$table->foreign('application_id')->references('id')->on('applications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('organisation_applications', function(Blueprint $table) {
			$table->foreign('organisation_id')->references('id')->on('organisations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('organisation_applications', function(Blueprint $table) {
			$table->dropForeign('organisation_applications_application_id_foreign');
		});
		Schema::table('organisation_applications', function(Blueprint $table) {
			$table->dropForeign('organisation_applications_organisation_id_foreign');
		});
	}
}