<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttachmentsTable extends Migration {

	public function up()
	{
		Schema::create('attachments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('type', array('image', 'pdf', 'binary'));
			$table->string('filename');
			$table->integer('filesize');
			$table->integer('order');
			$table->enum('privacy', array('public', 'document', 'private'));
		});
	}

	public function down()
	{
		Schema::drop('attachments');
	}
}